/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis.filesystem;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.utils.PathUtils;
import org.sonarsource.sonarlint.core.client.api.common.analysis.ClientInputFile;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.FileMetadata;

public class SonarLintInputFile
extends DefaultInputFile {
    private final ClientInputFile clientInputFile;

    public SonarLintInputFile(ClientInputFile clientInputFile) {
        super(null, null);
        this.clientInputFile = clientInputFile;
    }

    public ClientInputFile getClientInputFile() {
        return this.clientInputFile;
    }

    @Override
    public String relativePath() {
        return this.absolutePath();
    }

    @Override
    public String absolutePath() {
        return PathUtils.sanitize(this.path().toString());
    }

    @Override
    public File file() {
        return this.path().toFile();
    }

    @Override
    public Path path() {
        return this.clientInputFile.getPath();
    }

    @Override
    public InputFile.Status status() {
        return InputFile.Status.ADDED;
    }

    @Override
    public String key() {
        return this.absolutePath();
    }

    @Override
    public String moduleKey() {
        throw SonarLintInputFile.unsupported();
    }

    private static UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException("Unsupported in SonarLint");
    }

    @Override
    public Charset charset() {
        Charset charset = this.clientInputFile.getCharset();
        return charset != null ? charset : Charset.defaultCharset();
    }

    public SonarLintInputFile init(FileMetadata.Metadata metadata) {
        this.setLines(metadata.lines);
        this.setLastValidOffset(metadata.lastValidOffset);
        this.setOriginalLineOffsets(metadata.originalLineOffsets);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SonarLintInputFile)) {
            return false;
        }
        SonarLintInputFile that = (SonarLintInputFile)o;
        return this.path().equals(that.path());
    }

    @Override
    public int hashCode() {
        return this.path().hashCode();
    }

    @Override
    public String toString() {
        return "[path=" + this.path() + "]";
    }

    @Override
    public boolean isFile() {
        return true;
    }
}

